/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_register_unexp_callback.c,v 1.7 2006/03/23 14:33:12 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"

MX_FUNC(mx_return_t)
mx_register_unexp_handler(struct mx_endpoint *ep, mx_unexp_handler_t handler, void *context)
{
  MX__MUTEX_LOCK(&ep->lock);
  ep->unexp_handler = handler;
  ep->unexp_handler_context = context;
  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;
}

MX_FUNC(mx_return_t)
mx_disable_progression(struct mx_endpoint *ep)
{
  MX__MUTEX_LOCK(&ep->lock);
  while (ep->in_handler)
    MX__EVENT_WAIT(&ep->in_handler_event, &ep->lock);
  ep->in_handler = 1;
  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;
}

MX_FUNC(mx_return_t)
mx_reenable_progression(struct mx_endpoint *ep)
{
  MX__MUTEX_LOCK(&ep->lock);
  ep->in_handler = 0;
  mx__luigi(ep);
  MX__EVENT_SIGNAL(&ep->in_handler_event);
  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;
}

/* binary compatibility with previous version */

static mx_matching_callback_t old_unexp_callback = NULL;

static mx_unexp_handler_action_t
mx_unexp_handler_wrapper(void *context,
			 mx_endpoint_addr_t source,
			 uint64_t match_value,
			 uint32_t length,
			 void *data_if_available)
{
  old_unexp_callback(context, match_value, (int) length);
  return MX_RECV_CONTINUE;
}

mx_return_t
mx_register_unexp_callback(struct mx_endpoint *ep, mx_matching_callback_t cb, void *context)
{
  if (cb) {
    old_unexp_callback = cb;
    return mx_register_unexp_handler(ep, &mx_unexp_handler_wrapper, context);
  } else {
    return mx_register_unexp_handler(ep, NULL, context);
  }
}
